<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/11/2018
 * Time: 11:11 PM
 */


namespace themes\porto\widgets;

use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;

/**
 * Class Menu
 *
 * Description of Menu
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package themes\porto\widgets
 */
class Menu extends \yii\widgets\Menu
{
    public $linkTemplate = '<a href="{url}"><i class="fa fa-{icon}" aria-hidden="true"></i><span>{label}</span></a>';

    public function init()
    {
        parent::init();
        Html::addCssClass($this->options, 'nav nav-main');
    }

    protected function renderItem($item)
    {
        if (isset($item['url'])) {
            $template = ArrayHelper::getValue($item, 'template', $this->linkTemplate);
            $icon = ArrayHelper::getValue($item, 'icon', 'bars');
            return strtr($template, [
                '{url}' => Html::encode(Url::to($item['url'])),
                '{label}' => $item['label'],
                '{icon}' => $icon
            ]);
        } else {
            $template = ArrayHelper::getValue($item, 'template', $this->labelTemplate);

            return strtr($template, [
                '{label}' => $item['label'],
            ]);
        }
    }

}