<?php

use teratech\erp\core\models\SystemModule;
use yii\gii\generators\model\Generator;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $form yii\widgets\ActiveForm */
/* @var $generator \teratech\erp\sdk\generators\model\Generator */
echo $form->field($generator, 'moduleName')->dropDownList($generator->getModules(), ['prompt' => 'Select Module']);
echo $form->field($generator, 'tableName')->textInput(['table_prefix' => $generator->getTablePrefix()]);
echo $form->field($generator, 'modelClass');
echo $form->field($generator, 'ns');
echo $form->field($generator, 'baseClass');
echo $form->field($generator, 'db');
echo $form->field($generator, 'useTablePrefix')->checkbox();
echo $form->field($generator, 'generateRelations')->dropDownList([
    Generator::RELATIONS_NONE => 'No relations',
    Generator::RELATIONS_ALL => 'All relations',
    Generator::RELATIONS_ALL_INVERSE => 'All relations with inverse',
]);
echo $form->field($generator, 'generateLabelsFromComments')->checkbox();
echo $form->field($generator, 'generateQuery')->checkbox();
echo $form->field($generator, 'queryNs');
echo $form->field($generator, 'queryClass');
echo $form->field($generator, 'queryBaseClass');
echo $form->field($generator, 'enableI18N')->checkbox();
echo $form->field($generator, 'messageCategory');
echo $form->field($generator, 'useSchemaName')->checkbox();

$id = Html::getInputId($generator, 'tableName');
$modelId = Html::getInputId($generator, 'modelClass');
$moduleId = Html::getInputId($generator, 'moduleName');
$nsId = Html::getInputId($generator, 'ns');
$ns = SystemModule::getAll('namespace', 'unique_id');
$jns = \yii\helpers\Json::encode($ns);
$this->registerJs(<<<JS

    var ns = $jns;

    $('#$moduleId').on('change',function() {
        \$val = $(this).val();
        $('#$nsId').val(ns[\$val]+"\\\\models");
    });
    $('#$id').on('change',function(){
        var tableName = $(this).val();
          var modelClass = '';
                    $.each(tableName.split('_'), function() {
                        if(this.length>0)
                            modelClass+=this.substring(0,1).toUpperCase()+this.substring(1);
                    });
        $('#$modelId').val(modelClass)
    });
JS
);
