<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace themes\porto\gii\generators\model;


/**
 * This generator will generate one or multiple ActiveRecord classes for the specified database table.
 *
 * @author ramaj93@yahoo.com
 * @since 0.2.0
 */
class Generator extends \yii\gii\generators\model\Generator
{
    public $moduleName;
    public $useTablePrefix = true;
    public $enableI18N = true;
    public $baseClass = 'teratech\erp\base\db\ActiveRecord';

    public function rules()
    {
        return array_merge(parent::rules(), [
            ['moduleName', 'required']
        ]);
    }

    public function getName()
    {
        return "Gene Model Generator";
    }

    function getModules()
    {
        return [];// SystemModule::getAll('name', 'unique_id');
    }

    public function stickyAttributes()
    {
        return array_diff(parent::stickyAttributes(), ['ns']);
    }
}
