<?php

use yii\helpers\Inflector;
use yii\helpers\StringHelper;

/* @var $this yii\web\View */
/* @var $generator yii\gii\generators\crud\Generator */

$urlParams = $generator->generateUrlParams();

echo "<?php\n";
?>

use yii\helpers\Html;
use modular\widgets\Panel;

/* @var $this \modular\web\View */
/* @var $model <?= ltrim($generator->modelClass, '\\') ?> */

$this->title = <?= $generator->generateString('Update ' . Inflector::camel2words(StringHelper::basename($generator->modelClass)) . ' : {name}', ['name' => '$model->' . $generator->getNameAttribute()]) ?>;
$this->params['breadcrumbs'][] = ['label' => <?= $generator->generateString(Inflector::pluralize(Inflector::camel2words(StringHelper::basename($generator->modelClass)))) ?>, 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model-><?= $generator->getNameAttribute() ?>, 'url' => ['view', <?= $urlParams ?>]];
$this->params['breadcrumbs'][] = <?= $generator->generateString('Update') ?>;

$this->params['actions'] = [
['label'=><?= $generator->generateString('Add New ' . Inflector::camel2words(StringHelper::basename($generator->modelClass))) ?>,'url'=>['create']],
['label'=><?= $generator->generateString('Delete ' . Inflector::camel2words(StringHelper::basename($generator->modelClass))) ?>,
'url'=>['delete',<?= $urlParams ?>],
'options'=>[
'data' => [
'confirm' => <?= $generator->generateString('Are you sure you want to delete ' . Inflector::camel2words(StringHelper::basename($generator->modelClass)) . "?") ?>,
'method' => 'post',
],
]
],
];
?>
<div class="<?= Inflector::camel2id(StringHelper::basename($generator->modelClass)) ?>-update">

    <?= "<?php " ?>Panel::begin(['title'=>Html::encode($this->title)]);?>
    <?= "<?= " ?>$this->render('_form', [
    'model' => $model,
    ]) ?>
    <?= "<?php " ?>Panel::end();?>

</div>
