<?php

use yii\helpers\Inflector;
use yii\helpers\StringHelper;

/* @var $this yii\web\View */
/* @var $generator yii\gii\generators\crud\Generator */

$urlParams = $generator->generateUrlParams();
$nameAttribute = $generator->getNameAttribute();

echo "<?php\n";
?>

use modular\helpers\Html;
use modular\widgets\Panel;
use modular\widgets\GridView;
use yii\helpers\Url;
<?= $generator->enablePjax ? 'use yii\widgets\Pjax;' : '' ?>

/* @var $this \modular\web\View */
<?= !empty($generator->searchModelClass) ? "/* @var \$searchModel " . ltrim($generator->searchModelClass, '\\') . " */\n" : '' ?>
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = <?= $generator->generateString(Inflector::pluralize(Inflector::camel2words(StringHelper::basename($generator->modelClass)))) ?>;
$this->params['breadcrumbs'][] = $this->title;
$this->params['actions'][] = ['label'=><?= $generator->generateString('Add ' . Inflector::camel2words(StringHelper::basename($generator->modelClass))) ?>,'url'=>['create']];
?>
<div class='row <?= Inflector::camel2id(StringHelper::basename($generator->modelClass)) ?>-index'>
    <div class="col-md-12">
        <?= "<?php "?>Panel::begin(['title'=>Html::encode($this->title)]);?>
        <?= $generator->enablePjax ? "<?php Pjax::begin(); ?>\n" : "\n" ?>
        <?php if ($generator->indexWidgetType === 'grid'): ?>
            <?= "<?=\n" ?>
            GridView::widget([
                'dataProvider' => $dataProvider,
                <?= !empty($generator->searchModelClass) ? "'filterModel' => \$searchModel,\n        'columns' => [\n" : "'columns' => [\n"; ?>
                    ['class' => '\yii\grid\SerialColumn'],
                    <?php
                    $count = 0;
                    if (($tableSchema = $generator->getTableSchema()) === false) {
                        foreach ($generator->getColumnNames() as $name) {
                            if (++$count < 6) {
                                echo "            '" . $name . "',\n";
                            } else {
                                echo "            // '" . $name . "',\n";
                            }
                        }
                    } else {
                        foreach ($tableSchema->columns as $column) {
                            $format = $generator->generateColumnFormat($column);
                            if (++$count < 6) {
                                echo "            '" . $column->name . ($format === 'text' ? "" : ":" . $format) . "',\n";
                            } else {
                                echo "            // '" . $column->name . ($format === 'text' ? "" : ":" . $format) . "',\n";
                            }
                        }
                    }
                    ?>
                    [
                        'class' => 'modular\widgets\ActionColumn',
                        'template' => '{view}{update}{delete}',
                    ]
                ]
            ]) ?>
        <?php endif; ?>
        <?= $generator->enablePjax ? "<?php Pjax::end(); ?>\n" : '' ?>
        <?= "<?php "?>Panel::end();?>
    </div>
</div>
