<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 4/5/2017
 * Time: 11:07 PM
 */


namespace themes\porto\gii\generators\crud;

use Yii;
use yii\helpers\Inflector;

/**
 * Class ModelGenerator
 *
 * Description of ModelGenerator
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package teratech\erp\sdk
 */
class Generator extends \yii\gii\generators\crud\Generator
{
    public $baseControllerClass = 'modular\web\security\Controller';


    /**
     * @return string name of the code generator
     */
    public function getName()
    {
        return "Porto CRUD Generator";
    }

    public function getDescription()
    {
        return "Easily generate Porto themed crud forms";
    }


    public function getModuleID()
    {
        if (($pos = strpos($this->controllerClass, 'modules')) !== false) {
            $str = substr($this->controllerClass, $pos + 8);
            $pos = strpos($str, "\\");
            $str = substr($str, 0, $pos);
            return Inflector::camel2id($str);
        }

        return 'app';

    }

    public function getViewPath()
    {
        if (empty($this->viewPath)) {
            if (strpos($this->controllerClass, 'modules') !== false) {
                $module = $this->getModuleID();
                return Yii::getAlias('@app/modules/' . $module . '/views/' . $this->getControllerID());
            } else {
                return Yii::getAlias('@app/views/' . $this->getControllerID());
            }
        } else {
            return Yii::getAlias($this->viewPath);
        }
    }

    public function generateColumnFormat($column)
    {
        switch ($column->name) {
            case"created_at":
            case "updated_at":
                return 'datetime';
            case "created_by":
            case "updated_by":
                return "user";
            case "status":
                return "status";
            case "active":
                return "boolean";
        }
        return parent::generateColumnFormat($column);
    }
}