<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/11/2018
 * Time: 4:50 PM
 */

/** @var $this yii\web\View */
Yii::setAlias("themes", __DIR__ . '/../');
$config = [
    'components' => [
        'assetManager' => [
            'bundles' => [
                'yii\web\JqueryAsset' => [
                    'sourcePath' => __DIR__ . '/files',
                    'js' => [
                        "vendors/jquery/jquery.js",
                    ],
                    'jsOptions' => [
                        'position' => \yii\web\View::POS_HEAD
                    ]
                ],
                'yii\bootstrap\BootstrapAsset' => [
                    'sourcePath' => __DIR__ . '/files',
                    'js' => [
                        "vendors/bootstrap/js/bootstrap.js"
                    ],
                    'css' => [
                        "vendors/bootstrap/css/bootstrap.css"
                    ],
                ],
                'yii\bootstrap\BootstrapPluginAsset' => [
                    'sourcePath' => __DIR__ . '/files',
                    'js' => [
                        "vendors/bootstrap/js/bootstrap.js"
                    ],
                    'css' => [
                        "vendors/bootstrap/css/bootstrap.css"
                    ],
                ],
            ],
        ]
    ]];

if (YII_ENV_DEV) {
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        'generators' => [
            'search-model' => [
                'class' => 'themes\porto\gii\generators\searchmodel\Generator'
            ],
            'crud' => [
                'class' => 'themes\porto\gii\generators\crud\Generator',
                'templates' => [
                    'default' => '@themes/porto/gii/generators/crud/default',
                    'singleton' => '@themes/porto/gii/generators/crud/singleton'
                ]
            ]
        ]
    ];
}

return $config;
?>

