<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/11/2018
 * Time: 3:38 PM
 */


namespace themes\porto\assets;

use themes\porto\BaseAsset;
use yii\bootstrap\BootstrapPluginAsset;
use yii\web\JqueryAsset;

/**
 * Class MainAsset
 *
 * Description of MainAsset
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package themes\porto\assets
 */
class MainAsset extends BaseAsset
{
    public $css = [
        'vendors/font-awesome/css/font-awesome.css',
        'stylesheets/theme.css',
        'stylesheets/skins/default.css',
        'stylesheets/theme-custom.css',
    ];


    public $js = [
        ['vendors/modernizr/modernizr.js',
            'position' => \yii\web\View::POS_HEAD

        ],
        'vendors/nanoscroller/nanoscroller.js',
        'javascripts/theme.js',
        'javascripts/theme.custom.js',
        'javascripts/theme.init.js',
    ];

    public $depends = [
        JqueryAsset::class,
        BootstrapPluginAsset::class
    ];
}