<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/12/2018
 * Time: 3:24 PM
 */
use yii\helpers\Url;
use yii\widgets\ActiveForm;

/** @var $this yii\web\View */
/** @var $client \frontend\models\ClientRegisterForm */
/** @var $company \frontend\models\CompanyRegisterForm */

$this->title = 'Register';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="listpgWraper">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-md-offset-3">
                <div class="userccount">
                    <div class="socialLogin">
                        <h5>Register new Account.</h5>
                    </div>
                    <div class="userbtns">
                        <ul class="nav nav-tabs">
                            <li class="<?= $candidate ?>"><a data-toggle="tab" href="#candidate">Candidate</a></li>
                            <li class="<?= $employer ?>"><a data-toggle="tab" href="#employer">Employer</a></li>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <div id="candidate" class="formpanel tab-pane fade in <?= $candidate ?>">
                            <?php $form1 = ActiveForm::begin() ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <?= $form1->field($client, 'first_name')->label(false)->textInput(['placeholder' => 'Enter First Name']) ?>
                                </div>
                                <div class="col-md-6">
                                    <?= $form1->field($client, 'middle_name')->label(false)->textInput(['placeholder' => 'Enter Middle Name']) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <?= $form1->field($client, 'last_name')->label(false)->textInput(['placeholder' => 'Enter Last Name']) ?>
                                </div>
                                <div class="col-md-6">
                                    <?= $form1->field($client, 'gender')->label(false)->dropDownList([
                                        'Male' => 'Male',
                                        'Female' => 'Female'
                                    ], ['prompt' => 'Select Gender']) ?>
                                </div>
                            </div>

                            <?= $form1->field($client, 'email')->label(false)->textInput(['placeholder' => 'Enter your email']) ?>

                            <?= $form1->field($client, 'phone')->label(false)->textInput(['placeholder' => 'Enter your phone']) ?>

                            <?= $form1->field($client, 'password')->label(false)->passwordInput(['placeholder' => 'Enter password']) ?>

                            <?= $form1->field($client, 'password_repeat')->label(false)->passwordInput(['placeholder' => 'Repeat password']) ?>

                            <div class="formrow">
                                <input type="checkbox" name="checkname" id="infotech">
                                <label for="infotech"></label>
                                Agree to terms
                            </div>
                            <input type="submit" class="btn" value="Register">
                            <?php ActiveForm::end() ?>
                        </div>
                        <div id="employer" class="formpanel tab-pane fade in <?= $employer ?>">
                            <?php $form2 = ActiveForm::begin() ?>

                            <?= $form2->field($company, 'legal_name')->label(false)->textInput(['placeholder' => 'Enter Company Name']) ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <?= $form2->field($company, 'type')->label(false)->dropDownList([
                                        'Public' => 'Public',
                                        'Private' => 'Private',
                                        'Government' => 'Government'
                                    ],['prompt'=>'Select Type']) ?>
                                </div>
                                <div class="col-md-6">
                                    <?= $form2->field($company, 'category')->label(false)->dropDownList([
                                        'Male' => 'Male',
                                        'Female' => 'Female'
                                    ], ['prompt' => 'Select Category']) ?>
                                </div>
                            </div>

                            <?= $form2->field($company, 'password')->label(false)->passwordInput(['placeholder' => 'Enter password']) ?>

                            <?= $form2->field($company, 'password_repeat')->label(false)->passwordInput(['placeholder' => 'Repeat password']) ?>

                            <div class="formrow">
                                <input type="checkbox" name="checkname" id="infotech-c">
                                <label for="infotech"></label>
                                Agree to terms
                            </div>
                            <input type="submit" class="btn" value="Register">
                            <?php ActiveForm::end() ?>
                        </div>
                    </div>
                    <div class="newuser"><i class="fa fa-user" aria-hidden="true"></i> Already a Member? <a
                                href="<?= Url::to(['site/login']) ?>">Login Here</a></div>
                </div>
            </div>
        </div>
    </div>
</div>
