<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/11/2018
 * Time: 1:35 PM
 */
use frontend\assets\AppAsset;
use frontend\assets\SliderAsset;
use frontend\theme\widgets\Breadcrumbs;
use yii\helpers\Url;

/** @var $this yii\web\View */

/* @var string $content */
SliderAsset::register($this);
AppAsset::register($this);
$this->beginPage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= Yii::$app->name . ' - ' . $this->title ?></title>
    <!-- Fav Icon -->
    <link rel="shortcut icon" href="<?= Url::base() ?>/images/favicon.png">
    <?php $this->head() ?>
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="js/html5shiv.min.js"></script>
    <script src="js/respond.min.js"></script>
    <![endif]-->
</head>
<?php $this->beginBody() ?>
<body>
<!-- Header start -->
<?= $this->render('_header') ?>
<!-- Header end -->
<div class="pageTitle">
    <div class="container">

        <div class="row">
            <div class="col-md-6 col-sm-6">
                <h1 class="page-heading"><?= $this->title ?></h1>
            </div>
            <div class="col-md-6 col-sm-6">
                <?= Breadcrumbs::widget(['links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],]); ?>
            </div>
        </div>
    </div>
</div>
<?= $content ?>

<!--Footer-->
<?= $this->render('_footer') ?>
<!--Footer end-->
<!-- Bootstrap's JavaScript -->
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
