<?php

/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/13/2018
 * Time: 11:43 AM
 */

/* @var $this \yii\web\View */
use yii\helpers\Url;

$this->title = 'Courses';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="listpgWraper">
    <div class="container">

        <!-- Page Title start -->
        <div class="pageSearch">
            <div class="row">
                <div class="col-md-3"><a href="#." class="btn"><i class="fa fa-file-text" aria-hidden="true"></i>
                        Enrolled Courses</a></div>
                <div class="col-md-9">
                    <div class="searchform">
                        <div class="row">
                            <div class="col-md-6 col-sm-3">
                                <input type="text" class="form-control" placeholder="Course Title">
                            </div>
                            <div class="col-md-5 col-sm-2">
                                <select class="form-control">
                                    <option>Industry</option>
                                </select>
                            </div>
                            <div class="col-md-1 col-sm-2">
                                <button class="btn"><i class="fa fa-search" aria-hidden="true"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page Title end -->

        <!-- Search Result and sidebar start -->
        <div class="row">
            <div class="col-md-3 col-sm-6">
                <!-- Side Bar start -->
                <div class="sidebar">
                    <!-- Course By Title -->
                    <div class="widget">
                        <h4 class="widget-title">Course By Title</h4>
                        <ul class="optionlist">
                            <li>
                                <input type="checkbox" name="checkname" id="webdesigner">
                                <label for="webdesigner"></label>
                                Web Designer <span>12</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="3dgraphic">
                                <label for="3dgraphic"></label>
                                3D Graphic Designer <span>33</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="graphic">
                                <label for="graphic"></label>
                                Graphic Designer <span>33</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="electronicTech">
                                <label for="electronicTech"></label>
                                Electronics Technician <span>33</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="webgraphic">
                                <label for="webgraphic"></label>
                                Web / Graphic Designer <span>33</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="brandmanager">
                                <label for="brandmanager"></label>
                                Brand Manager <span>33</span></li>
                        </ul>
                        <!-- title end -->
                        <a href="#.">View More</a></div>

                    <!-- Course By Industry -->
                    <div class="widget">
                        <h4 class="widget-title">Course By Industry</h4>
                        <ul class="optionlist">
                            <li>
                                <input type="checkbox" name="checkname" id="infotech">
                                <label for="infotech"></label>
                                Information Technology <span>22</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="advertise">
                                <label for="advertise"></label>
                                Advertising/PR <span>45</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="services">
                                <label for="services"></label>
                                Services <span>44</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="health">
                                <label for="health"></label>
                                Health &amp; Fitness <span>88</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="mediacomm">
                                <label for="mediacomm"></label>
                                Media/Communications <span>22</span></li>
                            <li>
                                <input type="checkbox" name="checkname" id="fashion">
                                <label for="fashion"></label>
                                Fashion <span>11</span></li>
                        </ul>
                        <a href="#.">View More</a></div>
                    <!-- Course By Industry end -->

                    <!-- button -->
                    <div class="searchnt">
                        <button class="btn"><i class="fa fa-search" aria-hidden="true"></i> Search Course</button>
                    </div>
                    <!-- button end-->
                </div>
                <!-- Side Bar end -->
            </div>
            <div class="col-md-3 col-sm-6 pull-right">
                <!-- Social Icons -->
                <div class="sidebar">
                    <h4 class="widget-title">Follow Us</h4>
                    <div class="social"><a href="http://www.twitter.com" target="_blank"><i class="fa fa-twitter-square"
                                                                                            aria-hidden="true"></i></a>
                        <a href="http://www.plus.google.com" target="_blank"><i class="fa fa-google-plus-square"
                                                                                aria-hidden="true"></i></a> <a
                                href="http://www.facebook.com" target="_blank"> <i class="fa fa-facebook-square"
                                                                                   aria-hidden="true"></i></a> <a
                                href="https://www.pinterest.com" target="_blank"><i class="fa fa-pinterest-square"
                                                                                    aria-hidden="true"></i></a> <a
                                href="https://www.youtube.com" target="_blank"><i class="fa fa-youtube-square"
                                                                                  aria-hidden="true"></i></a> <a
                                href="https://www.linkedin.com" target="_blank"><i class="fa fa-linkedin-square"
                                                                                   aria-hidden="true"></i></a></div>
                    <!-- Social Icons end -->
                </div>
            </div>
            <div class="col-md-6 col-sm-12">
                <!-- Search List -->
                <ul class="searchList">
                    <!-- Course start -->
                    <li>
                        <div class="row">
                            <div class="col-md-8 col-sm-8">
                                <div class="jobimg"><img src="<?= Url::base() ?>/images/course/course_1.jpg"
                                                         alt="Job Name"></div>
                                <div class="jobinfo">
                                    <h3><a href="<?= Url::to(['course/view']) ?>">Database Design</a></h3>
                                    <div class="companyName"><a href="<?= Url::to(['course/view']) ?>">Database
                                            Management Company</a></div>
                                    <div class="location"><label class="fulltime">Video</label> - <span>1:30 mins</span>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div class="col-md-4 col-sm-4">
                                <div class="listbtn"><a href="<?= Url::to(['course/view']) ?>">Apply Now</a></div>
                            </div>
                        </div>
                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce venenatis arcu est. Phasellus
                            vel dignissim tellus. Aenean fermentum fermentum convallis.</p>
                    </li>
                    <!-- Course end -->
                </ul>

                <!-- Pagination Start -->
                <div class="pagiWrap">
                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                            <div class="showreslt">Showing 1-10</div>
                        </div>
                        <div class="col-md-8 col-sm-8 text-right">
                            <ul class="pagination">
                                <li class="active"><a href="#.">1</a></li>
                                <li><a href="#.">2</a></li>
                                <li><a href="#.">3</a></li>
                                <li><a href="#.">4</a></li>
                                <li><a href="#.">5</a></li>
                                <li><a href="#.">6</a></li>
                                <li><a href="#.">7</a></li>
                                <li><a href="#.">8</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Pagination end -->
            </div>
        </div>
    </div>
</div>