<?php

namespace frontend\models;

use common\models\Applicant;
use common\models\ClientForm;
use common\models\Person;

/**
 * Signup form
 */
class SignupForm extends Applicant
{

    public $password;
    public $repeat_password;

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['repeat_password', 'password'], 'required'],
            ['password', 'string', 'min' => 8],
            ['email', 'trim'],
            ['email', 'email'],
            ['email', 'unique', 'targetClass' => '\common\models\Applicant', 'message' => 'This email has already been taken.'],
            ['repeat_password', 'compare', 'compareAttribute' => 'password', 'message' => "Passwords don't match"],
        ]);
    }

    /**
     * @inheritdoc
     */
    public function rulesEx()
    {
        return array_merge(parent::rules(), [
            [['email','mobile', 'first_name', 'last_name', 'password'], 'required'],
            ['email', 'unique', 'targetClass' => '\common\models\Applicant', 'message' => 'This email has already been taken.'],
            ['email', 'trim'],
            ['email', 'required'],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['password', 'required'],
            ['password', 'string', 'min' => 8],
        ]);
    }

    public function signup()
    {
        $this->setPassword($this->password);
        $this->generateAuthKey();
        $this->status = 0;
        return $this->save();
    }


}
