<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/26/2017
 * Time: 7:21 PM
 */


namespace frontend\models;

use common\models\Applicant;

/**
 * Class ProfileForm
 *
 * Description of ProfileForm
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package frontend\models
 */
class ProfileForm extends Applicant
{
    public $address;
    public $city;

    public function afterFind()
    {
        parent::afterFind();
        $items = explode(",", $this->location);
        if (count($items) > 1) {
            $this->address = $items[0];
            $this->city = trim($items[1]);
        }
    }

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['address', 'city'], 'required']
        ]);
    }

}