<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/13/2018
 * Time: 4:36 PM
 */


namespace frontend\models;

use common\models\Employer;

/**
 * Class CompanyRegisterForm
 *
 * Description of CompanyRegisterForm
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package frontend\models
 */
class CompanyRegisterForm extends Employer
{
    public $password;
    public $password_repeat;

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['legal_name','password','password_repeat'], 'required'],
            ['password_repeat', 'compare', 'compareAttribute' => 'password']
        ]);
    }

    public function attributeLabels()
    {
        return array_merge(parent::attributeLabels(), [
            'legal_name' => 'Company Name'
        ]);
    }
}