<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/13/2018
 * Time: 3:56 PM
 */


namespace frontend\models;

use common\models\Candidate;

/**
 * Class CandidateForm
 *
 * Description of CandidateForm
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package frontend\models
 */
class ClientRegisterForm extends Candidate
{
    public $email;
    public $phone;
    public $password;
    public $password_repeat;

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['email', 'password', 'password_repeat', 'phone', 'gender'], 'required'],
            ['password_repeat', 'compare', 'compareAttribute' => 'password']
        ]);
    }
}