<?php

namespace frontend\models;

use yii\base\Model;

/**
 * Signup form
 */
class ChangePasswordForm extends Model
{
    public $old_password;
    public $password;
    public $repeat_password;

    public function rules()
    {
        return [
            [['repeat_password', 'password', 'old_password'], 'required'],
            ['password', 'string', 'min' => 8],
            ['email', 'trim'],
            ['email', 'email'],
            ['repeat_password', 'compare', 'compareAttribute' => 'password', 'message' => "Passwords don't match"],
        ];
    }


    public function signup()
    {
        $this->setPassword($this->password);
        $this->generateAuthKey();
        $this->status = 0;
        return $this->save();
    }


}
