<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/27/2017
 * Time: 4:45 PM
 */


namespace frontend\components;

use common\models\Applicant;
use common\models\ApplicantJob;
use common\models\Job;
use common\models\Location;

/**
 * Class JobFactory
 *
 * Description of JobFactory
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package frontend\components
 */
class JobFactory
{
    /**
     *
     */
    public static function getJobLocations()
    {
        $q = <<<SQL
          SELECT l.region name,count(j.id) jobs FROM location l JOIN job j ON j.location_id = l.id GROUP BY l.id ORDER BY count(j.id) DESC 
SQL;
        return db()->createCommand($q)->queryAll();
    }

    public static function getJobPositions()
    {
        $q = <<<SQL
          SELECT title,count(id) jobs FROM job GROUP BY title
SQL;
        return db()->createCommand($q)->queryAll();
    }

    public static function hasNotApplied($jobId, $userId = false)
    {
        if ($userId == false) {
            $userId = \Yii::$app->user->id;
        }
        $q = "select * from applicant_job WHERE applicant_id = {$userId} and job_id = {$jobId}";
        return db()->createCommand($q)->queryOne() == false;
    }

    public static function countActiveJobs()
    {
        return Job::find()->where(['status' => 1])->count();
    }

    public static function countActiveApplicants()
    {
        return Applicant::find()->where(['status' => 10])->count();
    }

    public static function countHired()
    {
        return ApplicantJob::find()->where(['status' => 1])->count();
    }

    public static function countLocations()
    {
        return Location::find()->count();
    }

    public static function getCurrentActive($count = 10)
    {
        return Job::find()->where(['status' => 1])->orderBy(['created_at' => SORT_DESC])->limit($count)->all();
    }

    public static function getTags()
    {
        $q = "SELECT tags FROM job WHERE status = 1 LIMIT 50";
        $models = db()->createCommand($q)->queryAll(7);
        $items = implode(",", $models);
        $tags = array_unique(explode(",", $items));
        return $tags;

    }
}