<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 7/30/2017
 * Time: 5:18 PM
 */


namespace frontend\components;

use frontend\models\ClientLoginForm;
use frontend\models\SignupForm;
use yii\web\Controller;

/**
 * Class BaseController
 *
 * Description of BaseController
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package common\components
 */
class BaseController extends Controller
{
    public $menu = [];

    public function init()
    {
        parent::init();
        $this->menu = [
            ['label' => 'Home', 'url' => ['site/index']],
            ['label' => 'About Us', 'url' => ['site/about']],
            ['label' => 'vacancies', 'url' => ['job/index'],
                'items' => [
                    ['label' => 'Browse', 'url' => ['job/browse']]
                ]],
            ['label' => 'Profile', 'url' => ['profile/index'],
                'items' => [
                    ['label' => 'Edit', 'url' => ['profile/update']]
                ],
                'visible' => !\Yii::$app->user->isGuest]
        ];
    }

}