<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 9/5/2017
 * Time: 10:57 AM
 */


namespace frontend\assets;

use yii\bootstrap\BootstrapPluginAsset;
use yii\web\AssetBundle;
use yii\web\JqueryAsset;

/**
 * Class CustomAsset
 *
 * Description of CustomAsset
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package frontend\assets
 */
class AppAsset extends AssetBundle
{

    public $baseUrl = "@web";
    public $basePath = "@webroot";

    public $css = [
        "js/revolution-slider/css/settings.css",
        "css/bootstrap.min.css",
        "css/font-awesome.css",
        "css/main.css",
    ];

    public $js = [
        "js/script.js",
    ];

    public $depends = [
        JqueryAsset::class,
        BootstrapPluginAsset::class
    ];
}