<?php

use yii\db\Migration;

/**
 * Handles the creation of table `employer`.
 */
class m180613_121738_create_employer_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('employer', [
            'id' => $this->primaryKey()->unsigned(),
            'client_id' => $this->integer()->unsigned()->notNull(),
            'name' => $this->string(50)->notNull(),
            'legal_name' => $this->string(100)->notNull(),
            'category' => $this->string(100)->notNull(),
            'type' => $this->string(50)->notNull(),
            'physical_address' => $this->string(100),
            'postal_address' => $this->string(50),
            'landline' => $this->string(15),
            'fax' => $this->string(15),
            'mobile' => $this->string(15),
            'email' => $this->string(200),
            'website' => $this->string(200),
            'logo' => $this->string(200),
            'about' => $this->text(),
            'create_at' => $this->bigInteger(),
            'updated_at' => $this->bigInteger()
        ], $tableOptions);


        $this->addForeignKey('fk_employer_client_id', 'employer', 'client_id', 'client', 'id');
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('employer');
    }
}
