<?php

use yii\db\Migration;

/**
 * Handles the creation of table `candidate`.
 */
class m180613_120938_create_candidate_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('candidate', [
            'id' => $this->primaryKey()->unsigned(),
            'client_id' => $this->integer()->unsigned()->notNull(),
            'image' => $this->string(200),
            'first_name' => $this->string(100)->notNull(),
            'middle_name' => $this->string(100),
            'last_name' => $this->string(100)->notNull(),
            'gender' => $this->string(10)->notNull(),
            'mobile_no' => $this->string(15)->notNull(),
            'country_code' => $this->string(3),
            'marital_status' => $this->string(10),
            'physical_address' => $this->string(100),
            'postal_address' => $this->string(50),
            'bio' => $this->text(),
            'twitter_link' => $this->string(),
            'fb_link' => $this->string(),
            'linkedin_link' => $this->string(),
            'website' => $this->string(),
            'create_at' => $this->bigInteger(),
            'updated_at' => $this->bigInteger()
        ], $tableOptions);

        $this->addForeignKey('fk_candidate_client_id', 'candidate', 'client_id', 'client', 'id');
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('candidate');
    }
}
