<?php

use yii\db\Migration;

/**
 * Handles the creation of table `client`.
 */
class m180613_120516_create_client_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('{{%client}}', [
            'id' => $this->primaryKey()->unsigned(),
            'username' => $this->string(200)->notNull(),
            'auth_key' => $this->string(32)->notNull(),
            'password_hash' => $this->string(200)->notNull(),
            'password_reset_token' => $this->string(200)->unique(),
            'type' => $this->smallInteger()->notNull(),
            'status' => $this->smallInteger()->defaultValue(0),
            'created_at' => $this->bigInteger(),
            'updated_at' => $this->bigInteger(),
        ], $tableOptions);

    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('client');
    }
}
