<?php

use yii\db\Migration;

/**
 * Handles the creation of table `setting`.
 */
class m180612_115128_create_setting_table extends Migration
{
    /**
     * @inheritdoc
     */
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }
        $this->createTable('{{%setting}}', [
            'id' => $this->primaryKey()->unsigned(),
            'site_name' => $this->string(200)->notNull(),
            'favicon' => $this->string(200),
            'logo' => $this->string(200),
            'site_status' => $this->smallInteger()->defaultValue(1),
            'site_description' => $this->string(500),
            'default_picture' => $this->string(200),
            'created_at' => $this->bigInteger(),
            'created_by' => $this->integer()->unsigned(),
            'updated_at' => $this->bigInteger(),
            'updated_by' => $this->integer()->unsigned()
        ], $tableOptions);


        $this->addForeignKey('fk_setting_created_by', 'user', 'created_by', 'user', 'id');
        $this->addForeignKey('fk_setting_updated_by', 'user', 'updated_by', 'user', 'id');
    }

    /**
     * @inheritdoc
     */
    public function down()
    {
        $this->dropTable('setting');
    }
}
