<?php

use yii\db\Migration;

class m130524_201442_init extends Migration
{
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey()->unsigned(),
            'username' => $this->string(250)->notNull()->unique(),
            'first_name' => $this->string(200)->notNull(),
            'last_name' => $this->string(200)->notNull(),
            'auth_key' => $this->string(32)->notNull(),
            'password_hash' => $this->string()->notNull(),
            'password_reset_token' => $this->string()->unique(),
            'type' => $this->string(50)->defaultValue("user"),
            'email' => $this->string()->notNull()->unique(),
            'status' => $this->smallInteger()->notNull()->defaultValue(1),
            'created_at' => $this->bigInteger(),
            'created_by' => $this->integer()->unsigned(),
            'updated_at' => $this->bigInteger(),
            'updated_by' => $this->integer()->unsigned()
        ], $tableOptions);

        $this->addForeignKey('fk_user_user_created_by','user','created_by','user','id');
        $this->addForeignKey('fk_user_user_updated_by','user','updated_by','user','id');

        $this->insert('{{%user}}', [
            'username' => 'admin@talenthub.com',
            'first_name' => 'Admin',
            'last_name' => 'istrator',
            'auth_key' => Yii::$app->security->generateRandomString(),
            'password_hash' => Yii::$app->security->generatePasswordHash('password'),
            'type' => 'Admin',
            'email' => 'admin@talenthub.com',
            'status' => 1,
            'created_at' => time(),
            'updated_at' => time(),
        ]);

    }

    public function down()
    {
        $this->dropTable('{{%user}}');
    }
}
