<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 6/9/2017
 * Time: 10:11 AM
 */


namespace console\controllers;

use common\helpers\App;
use common\models\Client;
use common\models\ClientIdentity;
use common\models\ClientIdentityService;
use common\models\ClientInvoice;
use common\models\Transaction;
use yii\console\Controller;

/**
 * Service container for various operations.
 *
 * Description of DefaultController
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package console\controllers
 */
class ServiceController extends Controller
{
    /**
     * Updates paid un-synced Invoices and their services
     */
    public function actionUpdateInvoices()
    {
        $models = ClientInvoice::findAll(['synced' => 0, 'status' => 1]); //full paid and not synced
        App::writeLine("Found " . count($models) . " full paid invoices");
        foreach ($models as $model) {
            /* @var $model ClientInvoice */
            $model->updateServices();
        }
        $models = ClientInvoice::findAll(['synced' => 0, 'status' => ClientInvoice::STATUS_PARTIALLY_PAID]); //full paid and not synced
        App::writeLine("Found " . count($models) . " partial paid invoices");
        foreach ($models as $model) {
            /* @var $model ClientInvoice */
            $model->updatePaidServices();
        }
    }

    /**
     * Update Invoice Payments
     */
    public function actionUpdatePayments()
    {
        $models = Transaction::findAll(['synced' => 0]);
        App::writeLine("Found " . count($models) . " transactions");
        foreach ($models as $model) {
            $model->updateInvoice();
        }
    }

    /**
     * Generates Client invoices
     */
    public function actionGenerateInvoices()
    {
        //minimum range is 1 month
        $now = time();
        $q =<<<SQL
      SELECT * FROM client_identity_service i WHERE status = 1 and (end_date - $now)<=28
SQL;
        $models = ClientIdentityService::findBySql($q)->all();
        var_dump($models);
    }
}