<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/28/2017
 * Time: 3:02 PM
 */


namespace console\controllers;

use common\models\Applicant;
use common\models\Job;
use common\models\Location;
use common\models\User;
use Faker\Factory;
use Faker\Generator;
use Yii;
use yii\console\Controller;

/**
 * Class FactoryController
 *
 * Description of FactoryController
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package console\controllers
 */
class FactoryController extends Controller
{
    /**
     * @var Generator
     */
    public $factory;

    public function init()
    {
        parent::init();
        $this->factory = Factory::create();
    }

    public function actionApplicants($count = 2)
    {
        $factory = $this->factory;
        for ($i = 0; $i < $count; $i++) {
            $model = new Applicant();
            $name = $factory->firstName;
            $model->location = $factory->city;
            $model->first_name = $name;
            $model->middle_name = $factory->firstNameMale;
            $model->marital_status = $factory->randomElement(['Married', 'Single', 'Divorced']);
            $model->gender = $factory->randomElement(['Male', 'Female']);
            $model->last_name = $factory->lastName;
            $model->password_hash = Yii::$app->getSecurity()->generatePasswordHash($name);
            $model->auth_key = Yii::$app->getSecurity()->generateRandomString();
            $model->status = $factory->randomElement([0, 10]);
            $model->bio = $factory->paragraph(10);
            $model->birth_date = $factory->unixTime;
            $model->email = $factory->email;
            $model->mobile = $factory->phoneNumber;
            echo $name . "\n";
            $model->save();
        }
    }

    public function actionJobs($count = 2)
    {
        $factory = $this->factory;
        for ($i = 0; $i < $count; $i++) {
            $model = new Job();
            $model->title = $factory->jobTitle;
            $model->location_id = $factory->randomElement(Location::getKeys());
            $model->description = $factory->paragraph(10);
            $model->responsibility = $factory->paragraph(5);
            $model->requirement = $factory->paragraph(5);
            $model->status = 10;
            $model->type = $factory->randomElement(['Full Time', 'Freelance', 'Part Time']);
            $model->tags = $factory->randomElement(['Administration', 'Management', 'IT',"Security"]);
            $model->created_at = time();
            $model->created_by = $factory->randomElement(User::getKeys());
            $model->updated_at = time();
            $model->updated_by = $factory->randomElement(User::getKeys());
            $model->status = 1;
            $model->save();
        }
    }
}