<?php

namespace common\models;

use common\components\ActiveRecord;
use Yii;

/**
 * This is the model class for table "{{%employer}}".
 *
 * @property string $id
 * @property string $client_id
 * @property string $name
 * @property string $legal_name
 * @property string $category
 * @property string $type
 * @property string $physical_address
 * @property string $postal_address
 * @property string $landline
 * @property string $fax
 * @property string $mobile
 * @property string $email
 * @property string $website
 * @property string $logo
 * @property string $about
 * @property string $create_at
 * @property string $updated_at
 *
 * @property Client $client
 */
class Employer extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%employer}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['client_id', 'name', 'legal_name', 'category', 'type'], 'required'],
            [['client_id', 'create_at', 'updated_at'], 'integer'],
            [['about'], 'string'],
            [['name', 'type', 'postal_address'], 'string', 'max' => 50],
            [['legal_name', 'category', 'physical_address'], 'string', 'max' => 100],
            [['landline', 'fax', 'mobile'], 'string', 'max' => 15],
            [['email', 'website', 'logo'], 'string', 'max' => 200],
            [['client_id'], 'exist', 'skipOnError' => true, 'targetClass' => Client::className(), 'targetAttribute' => ['client_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'client_id' => Yii::t('app', 'Client ID'),
            'name' => Yii::t('app', 'Name'),
            'legal_name' => Yii::t('app', 'Legal Name'),
            'category' => Yii::t('app', 'Category'),
            'type' => Yii::t('app', 'Type'),
            'physical_address' => Yii::t('app', 'Physical Address'),
            'postal_address' => Yii::t('app', 'Postal Address'),
            'landline' => Yii::t('app', 'Landline'),
            'fax' => Yii::t('app', 'Fax'),
            'mobile' => Yii::t('app', 'Mobile'),
            'email' => Yii::t('app', 'Email'),
            'website' => Yii::t('app', 'Website'),
            'logo' => Yii::t('app', 'Logo'),
            'about' => Yii::t('app', 'About'),
            'create_at' => Yii::t('app', 'Create At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClient()
    {
        return $this->hasOne(Client::className(), ['id' => 'client_id']);
    }
}
