<?php

namespace common\models;

use common\components\ActiveRecord;
use Yii;

/**
 * This is the model class for table "candidate".
 *
 * @property string $id
 * @property string $client_id
 * @property string $image
 * @property string $first_name
 * @property string $middle_name
 * @property string $last_name
 * @property string $gender
 * @property string $mobile_no
 * @property string $country_code
 * @property string $marital_status
 * @property string $physical_address
 * @property string $postal_address
 * @property string $bio
 * @property string $twitter_link
 * @property string $fb_link
 * @property string $linkedin_link
 * @property string $website
 * @property string $create_at
 * @property string $updated_at
 *
 * @property Client $client
 */
class Candidate extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'candidate';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['client_id', 'first_name', 'last_name', 'gender', 'mobile_no'], 'required'],
            [['client_id', 'create_at', 'updated_at'], 'integer'],
            [['bio'], 'string'],
            [['image'], 'string', 'max' => 200],
            [['first_name', 'middle_name', 'last_name', 'physical_address'], 'string', 'max' => 100],
            [['gender', 'marital_status'], 'string', 'max' => 10],
            [['mobile_no'], 'string', 'max' => 15],
            [['country_code'], 'string', 'max' => 3],
            [['postal_address'], 'string', 'max' => 50],
            [['twitter_link', 'fb_link', 'linkedin_link', 'website'], 'string', 'max' => 255],
            [['client_id'], 'exist', 'skipOnError' => true, 'targetClass' => Client::className(), 'targetAttribute' => ['client_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'client_id' => Yii::t('app', 'Client ID'),
            'image' => Yii::t('app', 'Image'),
            'first_name' => Yii::t('app', 'First Name'),
            'middle_name' => Yii::t('app', 'Middle Name'),
            'last_name' => Yii::t('app', 'Last Name'),
            'gender' => Yii::t('app', 'Gender'),
            'mobile_no' => Yii::t('app', 'Mobile No'),
            'country_code' => Yii::t('app', 'Country Code'),
            'marital_status' => Yii::t('app', 'Marital Status'),
            'physical_address' => Yii::t('app', 'Physical Address'),
            'postal_address' => Yii::t('app', 'Postal Address'),
            'bio' => Yii::t('app', 'Bio'),
            'twitter_link' => Yii::t('app', 'Twitter Link'),
            'fb_link' => Yii::t('app', 'Fb Link'),
            'linkedin_link' => Yii::t('app', 'Linkedin Link'),
            'website' => Yii::t('app', 'Website'),
            'create_at' => Yii::t('app', 'Create At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClient()
    {
        return $this->hasOne(Client::className(), ['id' => 'client_id']);
    }
}
