<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/20/2017
 * Time: 5:00 PM
 */


namespace common\helpers;

use yii\console\Application as Console;
use yii\web\Application as Web;

/**
 * Class App
 *
 * Description of App
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package common\helpers
 */
class App
{
    public static function isConsoleApp()
    {
        return \Yii::$app instanceof Console;
    }

    public static function writeLine($message)
    {
        if (self::isConsoleApp()) {
            \Yii::$app->controller->stdout(date("d-m-Y H:i:s ").$message . "\n");
        }
    }

    public static function errorLine($message)
    {
        if (self::isConsoleApp()) {
            \Yii::$app->controller->stderr($message . "\n");
        }
    }

    public static function isWebApp()
    {
        return \Yii::$app instanceof Web;
    }
}