<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/13/2017
 * Time: 10:22 PM
 */


namespace common\components;

use common\models\Applicant;
use common\models\Country;
use common\models\Job;
use common\models\Location;
use themes\metronic45\helpers\Html;

/**
 * Class Formatter
 *
 * Description of Formatter
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package common\components
 */
class Formatter extends \modular\Formatter
{
    public function asStatus($value)
    {
        if ($value === null) {
            return "Not Set";
        }
        $statues = Constants::$statuses;
        if (isset($statues[$value])) {
            return $statues[$value];
        }
        return "Unknown";
    }

    public function asApplicant_status($value)
    {
        if ($value === null) {
            return "Not Set";
        }

        switch ($value) {
            case 0:
                return "Inactive";
            case 10:
                return "Active";
            case 2:
                return "Paid Partially";
            case 3:
                return "Cancelled";
            default:
                return "Unknown";
        }
    }

    public function asUser_status($value)
    {
        if ($value === null) {
            return "Not Set";
        }

        switch ($value) {
            case 0:
                return "Inactive";
            case 10:
                return "Active";
            case 2:
                return "Paid Partially";
            case 3:
                return "Cancelled";
            default:
                return "Unknown";
        }
    }


    public function asLocation($value)
    {
        if ($value === null) {
            return "Not Set";
        }
        $model = Location::findOne($value);
        if ($model != false) {
            return $model->name . "," . $model->region;
        }
        return "Unknown";
    }

    public function asApplicant($value)
    {
        if ($value === null) {
            return "Not Set";
        }
        $model = Applicant::findOne($value);
        if ($model != false) {
            return $model->name;
        }
        return "Unknown";
    }

    public function asCountry($value)
    {
        if ($value === null) {
            return "Not Set";
        }
        $model = Country::findOne($value);
        if ($model != false) {
            return $model->name;
        }
        return "Unknown";
    }

    public function asNationality($value)
    {
        if ($value === null) {
            return "Not Set";
        }
        $model = Country::findOne($value);
        if ($model != false) {
            return $model->nationality;
        }
        return "Unknown";
    }

    public function asJob($value)
    {
        if ($value === null) {
            return "Not Set";
        }
        $model = Job::findOne($value);
        if ($model != false) {
            return $model->title;
        }
        return "Unknown";
    }

    public function asInterview($value)
    {
        if ($value === null) {
            return "Not Set";
        }

        switch ($value) {
            case 0:
                return "Pending";
            case 1:
                return "Recruited";
            case 2:
                return "Failed";
            case 3:
                return "Removed";
            default:
                return "Unknown";
        }
    }

    public function asInterview_status($value)
    {
        if ($value === null) {
            return "Not Set";
        }

        switch ($value) {
            case 0:
                return "Pending";
            case 1:
                return "Recruited";
            case 2:
                return "Failed";
            case 3:
                return "Removed";
            default:
                return "Unknown";
        }
    }
}