<?php

/* @var $this yii\web\View */
use themes\porto\widgets\ActiveForm;
use yii\helpers\Html;

/* @var $form ActiveForm */
/* @var $model \backend\models\LoginForm */


$this->title = 'Login';
?>
<!-- BEGIN LOGIN FORM -->

<div class="center-sign">
    <a href="/" class="logo pull-left">
        <img src="assets/images/logo.png" height="54" alt="Porto Admin"/>
    </a>

    <div class="panel panel-sign">
        <div class="panel-title-sign mt-xl text-right">
            <h2 class="title text-uppercase text-bold m-none"><i class="fa fa-user mr-xs"></i> Sign In</h2>
        </div>
        <div class="panel-body">
            <?php $form = ActiveForm::begin(['id' => 'login-form',
                'options' => ['class' => 'login-form'],
                'layout' => 'horizontal',
                'fieldConfig' => [
                    'options' => ['class' => 'form-group mb-lg'],
                    'wrapperOptions' => [
                        'class' => 'form-group mb-lg'
                        //'tag' => null,
                    ]
                ]
            ]); ?>

            <?= $form->field($model, 'username')->textInput(['autocomplete' => 'off', 'class' => 'form-control input-lg', 'placeholder' => 'Username'])->label(null, ['class' => '']) ?>
            <?= $form->field($model, 'password',[
                    'template'=>"            <div class='clearfix'>
                {label}
                <a href='pages-recover-password.html' class='pull-right'>Lost Password?</a>
            </div>\n{input}\n{hint}\n{error}"
            ])
                ->passwordInput(['autocomplete' => 'off', 'class' => 'form-control input-lg', 'placeholder' => 'Username'])
                ->label(null, ['class' => '']) ?>
            <div class="row">
                <div class="col-sm-8">
                    <div class="checkbox-custom checkbox-default">
                        <input id="RememberMe" name="rememberme" type="checkbox"/>
                        <label for="RememberMe">Remember Me</label>
                    </div>
                </div>
                <div class="col-sm-4 text-right">
                    <button type="submit" class="btn btn-primary hidden-xs">Sign In</button>
                    <button type="submit" class="btn btn-primary btn-block btn-lg visible-xs mt-lg">Sign In
                    </button>
                </div>
            </div>

            <?php ActiveForm::end() ?>
        </div>
    </div>
    <p class="text-center text-muted mt-md mb-md">&copy; Copyright 2014. All Rights Reserved.</p>
</div>
