<?php
/* @var $this yii\web\View */
/* @var $name string */
/* @var $message string */
/* @var $exception Exception */

use themes\metronic45\bundles\ErrorAsset;
use yii\helpers\Html;
use yii\web\HttpException;

ErrorAsset::register($this);

if ($exception instanceof HttpException) {
    /* @var $exception HttpException */
    $code = $exception->statusCode;
} else {
    $code = $exception->getCode();
}

$this->title = $name;
$this->params['breadcrumbs'][] = ['label' => "Errors", 'url' => '#'];
$this->params['breadcrumbs'][] = $code;
?>
<div class="row">
    <div class="col-md-12 page-404">
        <div class="number font-green"> <?= $code ?></div>
        <div class="details">
            <h3><?= Html::encode($this->title) ?></h3>
            <p> <?= nl2br(Html::encode($message)) ?>
                <br>
                <a href="<?= \yii\helpers\Url::home() ?>"> Return home </a></p>
        </div>
    </div>
</div>
