<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/13/2017
 * Time: 6:46 PM
 */


namespace backend\models;

use common\models\ClientFile;
use common\models\IdentityFile;
use yii\web\UploadedFile;

/**
 * Class FileForm
 *
 * Description of FileForm
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package backend\models
 */
class FileForm extends ClientFile
{

    public $name;
    public $file;

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['name', 'file'], 'required']
        ]);
    }

    public function upload()
    {
        $file = UploadedFile::getInstance($this, 'file');
        if ($file != false) {
            if ($this->isNewRecord) {
                $model = new IdentityFile();
                $model->generateCode();
            } else {
                $model = $this->identityFile;
            }
            $content = file_get_contents($file->tempName);
            $model->content = $content;
            $model->size = $file->size;
            $model->generateHash();
            $this->file = $file->name;
            return $model->save();
        }
        return false;
    }
}