<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/8/2017
 * Time: 12:55 PM
 */


namespace backend\models;

use common\models\Contact;
use common\models\VendorContact;

/**
 * Class ContactForm
 *
 * Description of ContactForm
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package backend\models
 */
class ContactForm extends VendorContact
{
    public $type;
    public $value;

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['type', 'value'], 'required']
        ]);
    }

    public function save($runValidation = true, $attributeNames = null)
    {
        if ($this->isNewRecord) {
            $model = new Contact();
        } else {
            $model = $this->contact;
        }
        $model->type = $this->type;
        $model->value = $this->value;
        if ($model->save()) {
            if ($this->isNewRecord) {
                $this->contact_id = $model->id;
                return parent::save($runValidation, $attributeNames);
            }
            return true;
        }
        $this->addErrors($model->errors);
        return false;
    }

    public function getTypes()
    {
        return Contact::getTypes();
    }
}