<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/6/2017
 * Time: 1:40 AM
 */


namespace backend\models;

use common\models\Client;
use common\models\Person;

/**
 * Class ClientForm
 *
 * Description of ClientForm
 *
 * @property string $first_name
 * @property string $last_name
 * @property string $middle_name
 * @property string $gender
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package backend\models
 */
class ClientForm extends Client
{
    private $_person = null;


    private function getParent()
    {
        if ($this->_person == null) {
            $this->_person = $this->person ?: new Person();
        }
        return $this->_person;
    }

    public function getFirst_name()
    {
        return $this->getParent()->first_name;
    }

    public function getLast_name()
    {
        return $this->getParent()->last_name;
    }

    public function getMiddle_name()
    {
        return $this->getParent()->middle_name;
    }

    public function setFirst_name($value)
    {
        $this->getParent()->first_name = $value;
    }

    public function setLast_name($value)
    {
        $this->getParent()->last_name = $value;
    }

    public function setMiddle_name($value)
    {
        $this->getParent()->middle_name = $value;
    }
}