<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/8/2017
 * Time: 12:55 PM
 */


namespace backend\models;

use common\models\ClientContact;
use common\models\Contact;

/**
 * Class ContactForm
 *
 * Description of ContactForm
 *
 * @property string $type
 * @property string $value
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package backend\models
 */
class ClientContactForm extends ClientContact
{
    public $_type;
    public $_value;


    public function afterFind()
    {
        parent::afterFind();
        $this->_type = $this->contact->type;
        $this->_value = $this->contact->value;
    }

    public function getType()
    {
        return $this->_type;
    }

    public function getValue()
    {
        return $this->_value;
    }

    public function rules()
    {
        return array_merge(parent::rules(), [
            [['type', 'value'], 'required']
        ]);
    }

    public function save($runValidation = true, $attributeNames = null)
    {
        if ($this->isNewRecord) {
            $model = new Contact();
        } else {
            $model = $this->contact;
        }
        $model->type = $this->type;
        $model->value = $this->value;
        if ($model->save()) {
            if ($this->isNewRecord) {
                $this->contact_id = $model->id;
                return parent::save($runValidation, $attributeNames);
            }
            return true;
        }
        $this->addErrors($model->errors);
        return false;
    }

    public function getTypes()
    {
        return Contact::getTypes();
    }
}