<?php
/*
 * Copyright (c) 2018 ramaj93@yahoo.com
 * All rights reserved.
 * Date: 6/1/2018
 * Time: 1:43 PM
 */


namespace backend\models;

use modular\base\Model;
use modular\traits\DateContainer;
use yii\helpers\Html;

/**
 * Class BaseReport
 *
 *
 * @property string $fromDateTime
 * @property string $toDateTime
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package backend\models
 */
class BaseReport extends Model
{
    use DateContainer;
    public $columns = [];
    public $dataProvider;
    public $content;
    public $export;
    public $title;
    public $layout = 'P';
    public $type;

    public $from;
    public $to;

    public function rules()
    {
        return [
            [['export', 'layout', 'from', 'to', 'type'], 'safe']
        ];
    }

    public function pdfButton()
    {
        $name = Html::getInputName($this, 'export');
        return Html::tag('button', '<i class="fa fa-file-pdf-o"></i>Pdf', array('name' => $name, 'value' => 'pdf', 'class' => 'btn red', 'formtarget' => '_blank'));
    }

    public function excelButton()
    {
        $name = Html::getInputName($this, 'export');
        return Html::tag('button', '<i class="fa fa-file-excel-o"></i>Excel', array('name' => $name, 'value' => 'excel', 'class' => 'btn green-meadow', 'formtarget' => '_blank'));
    }


    public function getFromDatetime()
    {
        return $this->toDbFormat('from');
    }

    public function getToDatetime()
    {
        return $this->toDbFormat('to');
    }

    public function getLayouts()
    {
        return array(
            'P' => 'Portrait',
            'L' => 'Landscape'
        );
    }
}