<?php
/*
 * Copyright (c) 2017 Teratech
 * All rights reserved.
 * Date: 8/28/2017
 * Time: 2:13 PM
 */


namespace backend\models;

use common\models\Applicant;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * Class ApplicantSearch
 *
 * Description of ApplicantSearch
 *
 * @author Ramadan Juma (ramaj93@yahoo.com)
 *
 * @package backend\models
 */
class ApplicantSearch extends Applicant
{
    public $job_id;
    public $age;
    public $education;
    public $experience;
    public $profile;
    public $age_range;

    public $interview_type;
    public $interview_date;

    public function attributeLabels()
    {
        return array_merge(parent::attributeLabels(), [
            'age_range' => 'Age Less Than'
        ]);
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['country_id', 'status', 'experience', 'profile', 'age_range'], 'integer'],
            [['interview_type', 'interview_date', 'age', 'first_name', 'education', 'middle_name', 'last_name', 'gender', 'email', 'mobile', 'image', 'marital_status', 'location',], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Applicant::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        if ($this->age) {
            $now = time();
            if ($this->age) {
                switch ($this->age_range) {
                    case 0: //great
                        $age = $this->age * 365 * 24 * 60 * 60;
                        $query->andWhere("($now - birth_date) > $age");
                        break;
                    case 1: //less
                        $age = $this->age * 365 * 24 * 60 * 60;
                        $query->andWhere("($now - birth_date) < $age");
                        break;
                    case 2:
                        //between
                        $ages = explode(",", $this->age);
                        if (count($ages) == 2) {
                            $age_1 = $ages[0] * 365 * 24 * 60 * 60;
                            $age_2 = $ages[1] * 365 * 24 * 60 * 60;
                            $query->andFilterWhere(['between', "($now - birth_date)", $age_1, $age_2]);
                        }
                        break;
                    default:
                }
            }
        }
        $with = [];
        if ($this->education) {
            $with[] = 'educations';
            $query->andWhere(['education.level' => $this->education]);
        }
        // grid filtering conditions
        $query->andFilterWhere([
            'country_id' => $this->country_id,
            'birth_date' => $this->birth_date,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'gender' => $this->gender,
            'applicant_job.job_id' => $this->job_id
        ]);

        $with[] = 'applications';
        $query->joinWith($with);

        $query->andFilterWhere(['like', 'first_name', $this->first_name])
            ->andFilterWhere(['like', 'middle_name', $this->middle_name])
            ->andFilterWhere(['like', 'last_name', $this->last_name])
            //->andFilterWhere(['like', 'gender', $this->gender])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'mobile', $this->mobile])
            ->andFilterWhere(['like', 'image', $this->image])
            ->andFilterWhere(['like', 'marital_status', $this->marital_status])
            ->andFilterWhere(['like', 'location', $this->location])
            ->andFilterWhere(['like', 'bio', $this->bio])
            ->andFilterWhere(['like', 'password_hash', $this->password_hash])
            ->andFilterWhere(['like', 'password_reset_token', $this->password_reset_token])
            ->andFilterWhere(['like', 'auth_key', $this->auth_key]);

        return $dataProvider;
    }
}