<?php

$params = array_merge(
    require(__DIR__ . '/../../common/config/params.php'),
    require(__DIR__ . '/../../common/config/params-local.php'),
    require(__DIR__ . '/params.php'),
    require(__DIR__ . '/params-local.php')
);
return [
    'id' => 'smartid-backend',
    'basePath' => dirname(__DIR__),
    'name' => 'Recruitment Admin',
    'controllerNamespace' => 'backend\controllers',
    'bootstrap' => ['log'],
    'language' => 'en-TZ',
    'timeZone' => 'Africa/Dar_es_Salaam',
    'modules' => [
    ],
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-smartid',
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_smartid-backend', 'httpOnly' => true],
        ],
        'session' => [
            // this is the name of the session cookie used for login on the backend
            'name' => 'smartid-backend',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                'image/code/<code>' => 'image/code',
                'image/code/<size>/<code>' => 'image/code',
                'image/file/<code>' => 'image/file'
            ],
        ]
    ],
    'params' => $params,
];
