<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace backend\components;

use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\web\Controller;

/**
 * Description of SecureController
 *
 * @author Ramadan
 */
class SecureController extends  Controller
{

    public $menu = [
        ['label' => 'Dashboard', 'icon' => 'home', 'url' => ['site/index']],
        [
            'label' => 'Applicants',
            'items' => [
                //['label' => 'Add', 'url' => ['applicant/create']],
                ['label' => 'Manage', 'url' => ['applicant/index']]
            ]
        ],
        [
            'label' => 'Applications',
            'icon' => 'envelope-letter',
            'items' => [
                //['label' => 'Add', 'url' => ['application/create']],
                ['label' => 'Manage', 'url' => ['application/index']]
            ]
        ],
        [
            'label' => 'Interviews',
            'icon' => 'bulb',
            'items' => [
                ['label' => 'Add', 'url' => ['interview/create']],
                ['label' => 'Manage', 'url' => ['interview/index']]
            ]
        ],
        [
            'label' => 'Jobs',
            'icon' => 'badge',
            'items' => [
                ['label' => 'Add', 'url' => ['job/create']],
                ['label' => 'Manage', 'url' => ['job/index']]
            ]
        ],
        [
            'label' => 'Users',
            'icon' => 'users',
            'items' => [
                ['label' => 'Add', 'url' => ['user/create']],
                ['label' => 'Manage', 'url' => ['user/index']]
            ]
        ],
        [
            'label' => 'Reports',
            'icon' => 'book-open',
            'items' => [
                ['label' => 'Applicants', 'url' => ['report/applicants']],
                ['label' => 'Applications', 'url' => ['report/applications']],
                ['label' => 'Interviews', 'url' => ['report/interviews']],
                ['label' => 'Applicant Interviews', 'url' => ['report/staff-interviews']],
                ['label' => 'Selections', 'url' => ['report/selections']]
            ]
        ],
        [
            'label' => 'Settings',
            'icon' => 'settings',
            'items' => [
                ['label' => 'Locations', 'icon' => 'globe', 'url' => ['location/index']],
                //['label' => 'Occupations', 'icon' => 'briefcase', 'url' => ['occupation/index']],
                ['label' => 'Audit Logs', 'icon' => 'list', 'url' => ['log/index']],
                ['label' => 'System', 'icon' => 'wrench', 'url' => ['setting/index']]
            ]
        ],
    ];

    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@']
                    ],
                    [
                        'allow' => FALSE,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

}
